# Enterprise-Grade Restaurant Management & QR Digital Menu System

Production-ready PHP + MySQL restaurant platform for cPanel/shared hosting with QR digital menu, kitchen display, admin dashboard, table management, billing/till, waiter role, and QR generator.

## Tech Stack
- Frontend: HTML5, CSS3, Vanilla JS
- Backend: PHP 8+ REST-style JSON APIs
- Database: MySQL (PDO + prepared statements)
- Real-time updates: AJAX polling every 3 seconds
- Server: Apache (cPanel compatible)

## Folder Structure

```
/public
    index.html
    menu.html
    kitchen.html
    admin.html
    waiter.html
    receipt.html
    assets/
/api
    auth/
    orders/
    menu/
    tables/
    billing/
    staff/
    qr/
config.php
.htaccess
database.sql
README.md
```

## Security Controls Implemented
- PDO only (no mysqli)
- Prepared statements in all database queries
- `password_hash()` and `password_verify()`
- PHP sessions for authentication
- Role-based access control: `admin`, `waiter`, `kitchen`, `customer`
- Input sanitization and validation
- Output escaping via `htmlspecialchars`
- `.htaccess` blocks direct `config.php` access
- HTTPS enforcement in root `.htaccess`
- SQL injection and XSS hardening
- Server-side bill total calculation only

## Setup on cPanel (Step-by-Step)

### 1) Upload Files
1. Zip the project locally.
2. In cPanel → **File Manager** → open `public_html` (or your selected document root).
3. Upload and extract project files.

Recommended deployment:
- Keep this full project in `public_html/cafe-qr/`
- Point domain/subdomain document root to `public_html/cafe-qr/public/`

### 2) Create MySQL Database
1. cPanel → **MySQL Databases**.
2. Create database: `aspkinte_qr`
3. Create user: `aspkinte_qr`
4. Set password: `+VGcLz3Rrd6ub3R#`
5. Add user to DB with **ALL PRIVILEGES**.

### 3) Import Schema
1. Open **phpMyAdmin**.
2. Select database `aspkinte_qr`.
3. Import `database.sql`.

### 4) Configure DB Credentials
Edit `config.php` and replace placeholders with:

- `DB_HOST = localhost`
- `DB_NAME = aspkinte_qr`
- `DB_USER = aspkinte_qr`
- `DB_PASS = +VGcLz3Rrd6ub3R#`

Do not hardcode credentials anywhere else.

### 5) Apache & Permissions
- Ensure root `.htaccess` remains enabled.
- Ensure `public/assets/uploads/` and `public/assets/qr/` are writable (`755`/`775` based on host policy).
- Ensure SSL is active (AutoSSL or custom cert) because HTTPS is enforced.

### 6) Login & Access
- Staff Login: `/index.html`
- Customer Menu: `/menu.html?table=T1`
- Kitchen Display: `/kitchen.html`
- Admin Dashboard: `/admin.html`
- Waiter Interface: `/waiter.html`

Seed users are created by `database.sql`:
- Username: `jayjack6461@gmail.com` (role `admin`)
- Username: `kitchen` (role `kitchen`)
- Username: `waiter` (role `waiter`)
- Admin password: `24jayarmyispro24`
- Default password for `kitchen` and `waiter`: `Admin@123`

If you want to rotate passwords immediately, login as admin and add new staff via API/UI, then deactivate old users in DB.

## API Response Format
All API endpoints return JSON:

Success:
```json
{
  "status": "success",
  "data": {}
}
```

Error:
```json
{
  "status": "error",
  "message": "Readable error message"
}
```

## Real-Time Behavior
- KDS, table states, and live feeds refresh every 3 seconds using `fetch()` polling.
- No Node.js/WebSocket requirement.

## Core Functional Coverage
- Customer QR Menu with categories, dietary tags, availability states, cart, order placement, add-to-active-order, waiter call
- Kitchen Display with urgency colors, item-level status updates, order grouping by table
- Admin dashboard with live feed, revenue (today/week/month), top-selling items, order history filters, CSV/PDF export, menu/table/billing controls, QR generation
- Table management: assign waiter, merge tables, move orders, mark cleaning, close table
- Menu management: category/item CRUD, image upload, availability states, schedule support, reorder endpoint
- Billing/till: itemized bill, manual charges, discount, tax/service config, split count, payment methods, archive closure, printable receipt
- Waiter role: assigned tables only + order updates + manual charges + table cleaning (no financial summary page)
- QR generator: table-wise unique URL and downloadable PNG with metadata stored in `qr_codes`

## Notes
- The frontend never accesses MySQL directly; all operations are API-driven.
- Ensure production `display_errors` is off in php.ini/cPanel for security.
- Back up database before schema changes.
