<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');

$user = current_user();
if (!$user) {
    json_error('Unauthenticated', 401);
}

$token = $_SESSION['session_token'] ?? '';
if ($token !== '') {
    $sessionStmt = $pdo->prepare('SELECT id FROM sessions WHERE session_token = :token AND expires_at > NOW() LIMIT 1');
    $sessionStmt->execute([':token' => $token]);
    if (!$sessionStmt->fetch()) {
        $_SESSION = [];
        session_destroy();
        json_error('Session expired', 401);
    }
}

json_success(['user' => $user]);