<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');
require_auth(['admin']);

$from = clean_string($_GET['from'] ?? date('Y-m-01'), 20);
$to = clean_string($_GET['to'] ?? date('Y-m-d'), 20);

$sql = "SELECT o.id AS order_id, t.table_number, o.status, b.grand_total, b.is_paid, o.created_at, b.closed_at
        FROM orders o
        INNER JOIN tables t ON t.id = o.table_id
        LEFT JOIN bills b ON b.order_id = o.id
        WHERE DATE(o.created_at) BETWEEN :from_date AND :to_date
        ORDER BY o.created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute([
    ':from_date' => $from,
    ':to_date' => $to
]);
$rows = $stmt->fetchAll();

$filename = 'orders_' . $from . '_to_' . $to . '.csv';
$output = fopen('php://temp', 'w+');
fputcsv($output, ['Order ID', 'Table', 'Status', 'Grand Total', 'Paid', 'Created At', 'Closed At']);
foreach ($rows as $row) {
    fputcsv($output, [
        $row['order_id'],
        $row['table_number'],
        $row['status'],
        $row['grand_total'],
        ((int) $row['is_paid'] === 1) ? 'Yes' : 'No',
        $row['created_at'],
        $row['closed_at']
    ]);
}

rewind($output);
$csvContent = stream_get_contents($output);
fclose($output);

json_success([
    'file_name' => $filename,
    'mime_type' => 'text/csv',
    'base64_content' => base64_encode((string) $csvContent)
]);