<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');
require_auth(['admin']);

$summarySql = "SELECT
    COALESCE(SUM(CASE WHEN DATE(p.paid_at) = CURDATE() THEN p.amount ELSE 0 END), 0) AS revenue_today,
    COALESCE(SUM(CASE WHEN YEARWEEK(p.paid_at, 1) = YEARWEEK(CURDATE(), 1) THEN p.amount ELSE 0 END), 0) AS revenue_week,
    COALESCE(SUM(CASE WHEN DATE_FORMAT(p.paid_at, '%Y-%m') = DATE_FORMAT(CURDATE(), '%Y-%m') THEN p.amount ELSE 0 END), 0) AS revenue_month
FROM payments p";

$summaryStmt = $pdo->query($summarySql);
$summary = $summaryStmt->fetch() ?: ['revenue_today' => 0, 'revenue_week' => 0, 'revenue_month' => 0];

$topSql = "SELECT oi.menu_item_id, oi.item_name_snapshot AS item_name, SUM(oi.quantity) AS total_qty
           FROM order_items oi
           INNER JOIN orders o ON o.id = oi.order_id
           WHERE o.created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)
           GROUP BY oi.menu_item_id, oi.item_name_snapshot
           ORDER BY total_qty DESC
           LIMIT 10";

$topStmt = $pdo->query($topSql);
$topItems = $topStmt->fetchAll();

$statusSql = "SELECT status, COUNT(*) AS total FROM tables WHERE restaurant_id = :restaurant_id GROUP BY status";
$statusStmt = $pdo->prepare($statusSql);
$statusStmt->execute([':restaurant_id' => 1]);
$tableStatus = $statusStmt->fetchAll();

json_success([
    'revenue' => [
        'today' => (float) $summary['revenue_today'],
        'week' => (float) $summary['revenue_week'],
        'month' => (float) $summary['revenue_month']
    ],
    'top_items' => $topItems,
    'table_status' => $tableStatus
]);