<?php
declare(strict_types=1);

require_once __DIR__ . '/bootstrap.php';

function ensure_image_upload(array $file): array
{
    if (!isset($file['tmp_name'], $file['name'])) {
        json_error('Invalid file upload', 422);
    }

    if ($file['error'] !== UPLOAD_ERR_OK) {
        json_error('Upload failed', 422);
    }

    $allowed = ['image/jpeg' => 'jpg', 'image/png' => 'png', 'image/webp' => 'webp'];
    $mime = mime_content_type($file['tmp_name']);
    if (!isset($allowed[$mime])) {
        json_error('Only JPG, PNG, WEBP are allowed', 422);
    }

    if ($file['size'] > 5 * 1024 * 1024) {
        json_error('File too large (max 5MB)', 422);
    }

    $ext = $allowed[$mime];
    $safeName = bin2hex(random_bytes(16)) . '.' . $ext;
    $destination = __DIR__ . '/../../public/assets/uploads/' . $safeName;

    if (!move_uploaded_file($file['tmp_name'], $destination)) {
        json_error('Failed to save file', 500);
    }

    return [
        'name' => $safeName,
        'path' => 'assets/uploads/' . $safeName
    ];
}