<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');
require_auth(['admin']);

$sql = "SELECT q.id, q.table_id, t.table_number, q.qr_data, q.image_path, q.generated_at
        FROM qr_codes q
        INNER JOIN tables t ON t.id = q.table_id
        ORDER BY q.id DESC";
$stmt = $pdo->query($sql);
$rows = $stmt->fetchAll();

foreach ($rows as &$row) {
    $row['id'] = (int) $row['id'];
    $row['table_id'] = (int) $row['table_id'];
    $row['table_number'] = esc_html((string) $row['table_number']);
    $row['qr_data'] = esc_html((string) $row['qr_data']);
    $row['image_path'] = esc_html((string) $row['image_path']);
}

json_success(['qr_codes' => $rows]);