<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');

$user = require_auth(['waiter', 'admin']);
$waiterId = $user['role'] === 'admin' ? (int) ($_GET['waiter_id'] ?? $user['id']) : (int) $user['id'];

$sql = "SELECT id, table_number, seats, status
        FROM tables
        WHERE restaurant_id = :restaurant_id AND assigned_waiter_id = :waiter_id
        ORDER BY table_number ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute([
    ':restaurant_id' => 1,
    ':waiter_id' => $waiterId
]);
$rows = $stmt->fetchAll();

foreach ($rows as &$row) {
    $row['id'] = (int) $row['id'];
    $row['seats'] = (int) $row['seats'];
    $row['table_number'] = esc_html((string) $row['table_number']);
}

json_success(['tables' => $rows]);